setwd("<your directory or folder path>")

n <- 36
n.tests <- 1
alpha_prime <- 0.05/n.tests
K0 <- 0.775
#
# This little bit of code makes a table
# to illustrate the relationships between Pr{In-Spec},
# z-score, population Cpk, and critical value
# for Cpk hypothesis test:
# H0: Cpk < K_list
# H1: Cpk >= K_list
#
prob_inspec <- c(0.9000,0.9100,0.9200,0.9300,0.9400,0.9500,0.9600,0.9610,0.9620,0.9630,0.9640,0.9650,0.9660,0.9670,0.9680,0.9690,0.9700,0.9800,0.9900, 0.9921, 0.9950, 0.9990, 0.9995, 0.9999, 0.9999999985)
Z0 <- qnorm(prob_inspec)
K_list <- Z0 / 3
Cpk_crit <- qt(p=alpha_prime,df=n-1,ncp=3*sqrt(n)*K_list)/(3*sqrt(n))
df_Cpk <- cbind(n,prob_inspec,Z0,K_list,Cpk_crit)

#
# n = 180 crit_val_Cpk = 0.550 K0 = 0.613
# n = 36 crit_val_Cpk = 0.625 K0 = 0.775
# n = 36 crit_val_Cpk = 0.651 K0 = 0.804
# n = 48 crit_val_Cpk = 0.809 K0 = 0.965 
# n = 48 crit_val_Cpk = 0.809 K0 = 1.0125 alpha_prime = 0.0125
# n = 36 crit_val_Cpk = 0.720 K0 = 0.885 alpha_prime = 0.05
# n = 36 crit_val_Cpk = 0.720 K0 = 0.949 alpha_prime = 0.0125
# n = 36 crit_val_Cpk = 0.840 K0 = 1.025, alpha_prime = 0.05
# n = 36 crit_val_Cpk = 1.630  K0 = 1.9567, alpha_prime = 0.05
#
#
#  This is the main part of the code.
#  crit_val_Cpk is the crticial value (minimum sample
#  Cpk required to reject H0 with 95% probabilty
#  if Cpk = K0)
#
noncenT <- qt(p=alpha_prime,df=n-1,ncp=3*sqrt(n)*K0)
crit_val_Cpk <- noncenT / (3*sqrt(n))

df2 <- cbind(n,alpha_prime,K0,noncenT,crit_val_Cpk)
write.csv(df2,"20180613 Cpk Critical Value.csv")

Kalts <- c(K0+0.12,K0+0.09,K0+0.06,K0+0.03, K0, K0-0.03, K0-0.06, K0-0.09, K0-0.12, K0-0.121, K0-0.122, K0-0.123, K0-0.124, K0-0.125, K0-0.126, K0-0.127, K0-0.128, K0-0.129, K0-0.13, K0-0.14, K0-0.15, K0-0.18, K0-0.21, K0-0.24, K0-0.27, K0-0.30, K0-0.31, K0-0.314, K0-0.32, K0-0.33, K0-0.36, K0-0.39, K0-.50, K0-.8, K0-1.00)
prob_reject <- pt(noncenT,df=n-1,ncp=3*sqrt(n)*Kalts)
prob_within <- 1 - 2*pnorm(-3*Kalts)

#compute approximate lower confidence limit for Cpk
CpkLim <- Kalts - qnorm(.95)*sqrt((1/(9*n)) + (Kalts**2)/(2*(n-1)))

#
# These calculations are for a skip-lot plan
# PaLots Formula from E. Schilling, Acceptance Sampling in Quality Control,
#                     ASQC Quality Press, 1982, p. 447
#
prob_out = 1 - prob_within
prob_accept <- 1 - prob_reject

#ipass <- 15
#freq <- 0.067
#PaLots <- (freq*prob_accept + (1-freq)*(prob_accept**ipass)) / (freq + (1-freq)*(prob_accept**ipass))
#
# End Skip-Lot Calculations
#
plot(Kalts,prob_accept,xlim=c(0.30,1.15),ylim=c(0.00,1.00), main="OC Curve for Cpk",sub="n=36, K0=Cpk(H0)=0.775, Cpk(crit.)=0.625",xlab="Pop. Cpk", ylab="Pr{PASS}",type="b")
abline(v=0.775)
abline(h=1-alpha_prime)
text(x=0.4,y=(1-alpha_prime-0.02),labels="95%")
text(x=0.670,y=0.0,labels="Cpk(H0)=0.775")
#plot(prob_within,prob_reject,xlim=c(0.90,1.00),ylim=c(0.00,1.00))
#dev.new()
#plot(prob_within,prob_accept,xlim=c(0.85,1.00),ylim=c(0.00,1.00), main="OC Curve for Cpk",sub="n=25, K0=Cpk(H0)=1.00, Cpk(crit.)=0.789",xlab="Pr{L<X<U}", ylab="Pr{REJECT H0: Cpk < K0}",type="b")
#abline(v=0.9973)
#abline(h=0.95)


df3 <- cbind(n,Kalts,prob_within,prob_reject,prob_accept,prob_out,CpkLim)

write.csv(df3,"20180808 Power for Cpk Test.csv")